/*:
 * @plugindesc パーティーコマンドの非表示やアクターコマンドを編集できます。
 * @author 村人C
 *
 * @help
 *
 * 使い方
 * プラグインコマンド：
 * Battle_Command_Extend 変更する箇所 フラグ
 *
 * 変更する箇所のパラメータ
 * Party   Attack   Skill   Guard    Item
 * Auto    Repeat   Escape
 *
 * フラグ
 * 有効： on
 * 無効： off
 *
 * 例： Battle_Command_Extend Skill on
 * スキルを非表示にします。
 * 
 * プラグインパラメータ：
 * 有効： on
 * 無効： off
 *
 * コマンドの並び順
 * 先頭のものほど上に表示されます。
 * 攻撃：  attack   スキル： skill   防御： guard    アイテム： item
 * 逃げる： escape   オート： auto    リピート： repeat
 *
 * オート
 * １ターンのみ個別に自動戦闘にします。
 *
 * リピート
 * 前のターンと同じ行動を取ります。
 *
 * Command_Flag
 * コマンドウインドウを自動でサイズ調整します。
 *
 * PT_Flag
 * パーティーコマンド非表示
 * on の場合、「逃げる」をアクターコマンドに追加します。
 *
 * Attack_Flag
 * 「攻撃」を非表示
 *
 * Skill_Flag
 * 「スキル」を非表示
 *
 * Guard_Flag
 * 「防御」を非表示
 *
 * Item_Flag
 * 「アイテム」を非表示
 *
 * Auto_Flag
 * 「オート」を非表示
 *
 * Repeat_Flag
 * 「リピート」を非表示
 *
 * Escape_Flag
 * 「逃げる」を非表示
 *
 *
 * 仕様
 * プラグインコマンドの大文字、小文字を間違えると正しく動作しません。
 * 「スキル」が非表示の場合に「オート」を選ぶと「通常攻撃」が選択されます。
 * パーティーコマンド時の「オート」は全アクターに適用されます。
 * 戦闘開始時に「リピート」を選択した場合、全アクターの行動が通常攻撃になります。
 * 「リピート」の判定はターン開始時です。ターン開始後、使用不可になった場合は行動しません。
 * ターン開始時に前のターンと同じ行動がコスト不足等で実行できない場合は通常攻撃になります。
 *
 * readmeやスタッフロールの明記、使用報告は任意
 *
 *
 * @param Auto
 * @desc 「オート」
 * デフォルト: オート
 * @default オート
 *
 * @param Repeat
 * @desc 「リピート」
 * デフォルト: リピート
 * @default リピート
 *
 * @param Command
 * @desc コマンドの並び
 * デフォルト: attack skill guard item auto repeat escape
 * @default attack skill guard item auto repeat escape
 *
 * @param Command_Flag
 * @desc コマンドのサイズを自動変更
 * デフォルト: on
 * @default on
 *
 * @param PT_Flag
 * @desc パーティーコマンド非表示
 * デフォルト: on
 * @default on
 *
 * @param Attack_Flag
 * @desc 「攻撃」を非表示
 * デフォルト: off
 * @default off
 *
 * @param Skill_Flag
 * @desc 「スキル」を非表示
 * デフォルト: off
 * @default off
 *
 * @param Guard_Flag
 * @desc 「防御」を非表示
 * デフォルト: off
 * @default off
 *
 * @param Item_Flag
 * @desc 「アイテム」を非表示
 * デフォルト: off
 * @default off
 *
 * @param Auto_Flag
 * @desc 「オート」を非表示
 * デフォルト: off
 * @default off
 *
 * @param Repeat_Flag
 * @desc 「リピート」を非表示
 * デフォルト: off
 * @default off
 *
 * @param Escape_Flag
 * @desc 「逃げる」を非表示
 * デフォルト: off
 * @default off
 *
 */